var bLoadingData = false;	//global var to determine if a change is being made to a row while loading
							//or due to changes made by the user. Should be set appropriately before and after
var bChangeDataduringLoad = false;							
							//loading data into cells Row colouring should be carried out only when changes
							//are made by the user
var group_range_index;
/*
group range:0 (0~127);
			1 (128~255);
			2 (256~383);
			3 (384~511);
			4 (512~639);
			5 (640~767);
			6 (768~895);
			7 (896~1023).
*/
var language;

var GROUP_DISPLAY_PER = 2;
var CAS_NUM = 6;
var ctrlName = new Array("a", "b", "c", "d", "e", "f", "g");

var BASE_ROW_HEIGHT;
var BASE_ROW_HEIGHT_INT;

var g_AcDataGroups = [];	// Contains array of strings - each element containing , separated values

function ToggleLoading()	// test function to toggle the global var for loading
{
	bLoadingData = !bLoadingData;
}

function DisableApply(bDisable)
{
	var Apply = document.getElementById("Apply");
	disabledButton(Apply, bDisable);
	/* If the Apply is being enabled during Load, set it to Disable again */
	if((bLoadingData == true) && (bDisable == false))
	{
		//disabledButton(Apply, true);
		bChangeDataduringLoad = true;
    }
}

function DisableReset(bDisable)
{
	document.getElementById("Reset").disabled = bDisable;
}

window.onload = function()
{
	//if(bd.browser == "IE")
	{
		BASE_ROW_HEIGHT = "144px";
		BASE_ROW_HEIGHT_INT = 144;
	}
	//else
	{
		//BASE_ROW_HEIGHT = "132px";
		//BASE_ROW_HEIGHT_INT = 132;
	}
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";

	language = document.getElementById("language").value;
	disabledButton(document.getElementById("Apply"), true);

	if(bLoadingData == false)
	{
		ToggleLoading();
	}

	DisableApply(true);
	DisableReset(true);
	
	var args = getArgs();
	var group = args["group"];
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	
	nodeId = parent.curTree.getSelectedNodes()[0].id;
	var str = nodeId.toString();
	var len = str.length;
	var acVal = Math.pow(10, (len - 1));
	group_range_index = parseInt(nodeId%acVal) - 1;
	
	GetAcConfigRows();
}

//var scrollLock = false;
function FillInternalTable(s_ac)
{
	var len = s_ac.length;
	for(var i = 0; i < len; i++)
	{
		if(s_ac[i] == "end")
		{
			continue;	// The last value is "end"
		}
		if(s_ac[i].indexOf("group_index") != -1)
		{
		// The current row is "group_index". Hence skip.
			continue;	
		}
		var rowFields = s_ac[i].split(",");
		
		var saveRowString = "C," + rowFields[0];
		for(var j = 1; j < rowFields.length; j++)
		{
			saveRowString = saveRowString + ",C&" + rowFields[j];	// When loading the rows are Clean
		}
		g_AcDataGroups.push(saveRowString);

		// Create a row in the invisible table - this is used in adjusting the scrollbar
		var row = document.getElementById("InvisibleTable").insertRow(-1);
		row.style.height = BASE_ROW_HEIGHT; // This value has to match the stream map row"s height. Only then the scrollbar"s thumb will be of proper size.
		var cell = row.insertCell(0);
		cell.innerHTML = g_AcDataGroups.length;
	}
}

function RenderBaseRow(groupNo, index, groupData)
{
	var fields = groupData.split(",");
	
	$("#" + ctrlName[0] + index).html(parseInt(fields[1]) + 1);
		
	for(var i=1; i<=CAS_NUM; i++)
	{
		var casData = fields[i + 1].split("&");
		if(casData[0] == "M")
		{
			$("#" + ctrlName[i] + index).css("backgroundColor", "yellow");
		}
		else
		{
			$("#" + ctrlName[i] + index).css("backgroundColor", "white");
		}
		$("#" + ctrlName[i] + index).val(casData[1]);
	}
}

function RenderBaseTable()
{
	var GroupNo = parseInt(document.getElementById("BaseTableDiv").scrollTop, 10);
	GroupNo = parseInt((GroupNo) / (BASE_ROW_HEIGHT_INT), 10); 
	
	for(var i = GroupNo; i < (GroupNo + GROUP_DISPLAY_PER); i++)
	{
		RenderBaseRow(i, (i - GroupNo), g_AcDataGroups[i]);
	}
}

var init_row = true;
var group_index;
function GetAcConfigRows()
{
	var xmlhttp = false;
	xmlhttp = getHTTPObject();

	if(init_row)
	{
		group_index = 0;
	}
	var getParams = "type=35&cmd=1&acGetString=" + group_range_index + "|" + group_index;

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if((xmlhttp.readyState == 4) && (xmlhttp.status == 200))
		{
			var response = xmlhttp.responseText;
			var s_ac_response = response.slice(7, -8).split("&");
			var s_ac_len = s_ac_response.length;

			FillInternalTable(s_ac_response);
			if(init_row == true)
			{
				RenderBaseTable();
			}

			init_row = false;
			
			if(s_ac_response[s_ac_len - 1].indexOf("group_index") != -1)
			{
				var cur_row_string = s_ac_response[s_ac_len - 1].split("=");
				group_index = cur_row_string[1]; 	//The element before-last in response array stores the value of "group_index"
			}

			if(s_ac_response[s_ac_len - 1] == "end")
			{
				init_row = true;
				if(bLoadingData == true)
				{
					ToggleLoading();
				}
				if(bChangeDataduringLoad)
				{
					DisableApply(false);
					bChangeDataduringLoad = false;
				}	
				DisableReset(false);

				document.body.style.cursor = "auto";
				window.status = "Done";
				return true;
			}
			setTimeout("GetAcConfigRows()", 5);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function validateAcData(obj)
{
	var AcData = obj.value;
	if(validateString(AcData, 256, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function OnAcGroupCellChange(obj)
{
	var GuiRowNo = parseInt(obj.id.substr(1), 10); 	// if id is "a2" GuiRowNo will be 2
	var groupIdx = parseInt($("#a" + GuiRowNo).html()) - 1;
	groupIdx = (groupIdx % 128);
	var rowValue = g_AcDataGroups[groupIdx]; 		// This will be , separated
	var rowFields = rowValue.split(",");

	// Find out which field has changed
	var fieldIndex = obj.id.charCodeAt(0) - 97 + 1; 	// 97 is the char code for "a"

	if(validateAcData(obj) == false)
	{
		return false;
	}
	
	// Update the row with the new value
	rowFields[fieldIndex] = "M&" + obj.value;
	rowFields[0] = "M";

	// Build a new row string and update g_StreamMapRows
	var newRowString = rowFields[0];
	for(var i = 1; i < rowFields.length; i++)
	{
		newRowString = newRowString + "," + rowFields[i];
	}
	g_AcDataGroups[groupIdx] = newRowString;

	RenderBaseRow(groupIdx, GuiRowNo, g_AcDataGroups[groupIdx]);

	DisableApply(false);
	DisableReset(false);
}

function OnBaseScroll()
{
	RenderBaseTable(); // TODO: Check if this can be moved inside the else condition above
}

function ValidateBeforeApply(data)
{
	for(var i=1; i<=CAS_NUM; i++)
	{
		var acData = data[i + 1].split("&");
		if(acData[0] == "M")
		{
			if(validateString(acData[1], 256, language) == false)
			{
				return false;
			}
		}
	}
	return true;
}

var modifyPerPost = 16;		
var modifyCount = 0;		//post modify group count
var modifyNumCnt;			//post modify loop count
var modifyRows = [];
var postString = "";
var loopModCnt = 1;

function setPostData()
{
	modifyNumCnt = parseInt(modifyCount / modifyPerPost);
	if((modifyCount % modifyPerPost) > 0)
	{
		modifyNumCnt = modifyNumCnt + 1;
	}
}

function setAcGroupData()
{
	var postModCnt;
	if(loopModCnt == modifyNumCnt)
	{
		var j = (loopModCnt - 1) * modifyPerPost;
		postModCnt =  modifyCount - j;
		for(var i = j; i < (j + postModCnt); i++)
		{
			if(i == j)
			{
				postString = modifyRows[i];
			}
			else
			{
				postString = postString + "|" + modifyRows[i];
			}
		}
		postString = postModCnt + "#" + postString;
		loopModCnt++;
		PostAcGroupRows(postString);
		return;
	}
	else if(loopModCnt < modifyNumCnt)
	{
		var j = (loopModCnt - 1) * modifyPerPost;
		for(var i = j; i < (j + modifyPerPost); i++)
		{
			if(i == j)
			{
				postString = modifyRows[i];
			}
			else
			{
				postString = postString + "|" + modifyRows[i];
			}
		}
		postString = postModCnt + "#" + postString;
		loopModCnt++;
		PostAcGroupRows(postString);
		return;
	}
	else if(loopModCnt > modifyNumCnt)
	{
		if(language == 0)
		{
			alert("AC groups modified successfully.");
		}
		else
		{
			alert("AC组设置成功。");
		}
		window.location.reload();
		return;
	}
}

function PostAcGroupRows(sValueString)
{
	var params = "type=35&cmd=2&acSetString=" + group_range_index + "#" + sValueString;

	var xmlhttp = false;
	
	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);

	xmlhttp.onreadystatechange = function()
   	{
    	if(xmlhttp.readyState == 4)
    	{
       		setTimeout("setAcGroupData()", 50);
		}
	}

	xmlhttp.send(params);
	return false;
}

function PerformReload()
{
	DisableApply(true);
	DisableReset(true);

	bLoadingData = true;
	
	// Clear displays
	var BaseTable = document.getElementById("BaseTableBody");
	for(var i = 0; i < 12; i++)
	{
		var Row = BaseTable.rows[i];
		var Child = Row.firstChild;

		while(Child != null)
		{
			if((Child.firstChild) && (Child.firstChild.nodeName == "INPUT"))
			{
				Child.firstChild.value = "";
			}
			Child = Child.nextSibling;
		}
	}

	g_AcDataGroups.length = 0;

	var len = document.getElementById("InvisibleTable").rows.length - 1;
	var table = document.getElementById("InvisibleTable");
	for(var i = 0; i < len; i++)
	{
		table.deleteRow(-1);
	}

	document.getElementById("BaseTableDiv").scrollTop = 0;

	GetAcConfigRows();
	//FillInternalTable(s_ac_response);
	//RenderBaseTable();
}

function PerformApply()
{
	var len = g_AcDataGroups.length;
	for(var i = 0; i < len; i++)
	{
		// Modified row
		if(g_AcDataGroups[i].slice(0,1) == "M")
		{
			var modRow;
			var data = g_AcDataGroups[i].split(",");
			if(ValidateBeforeApply(data) == false)
			{
				DisableApply(false);
				DisableReset(false);
				document.body.style.cursor = "auto";
				window.status = "Done";
				return false;
			}
			else
			{
				DisableApply(true);
				DisableReset(true);

				window.status = "Applying settings, please wait...";
				document.body.style.cursor = "wait";
			}
			// Modified row
			modifyCount++;

			modRow = data[1]; // Local index (index within the channel)
			for(var j = 1; j <= CAS_NUM; j++)
			{
				var acData = data[j + 1].split("&");
				modRow = modRow + "," + acData[1];
			}
			modifyRows.push(modRow);
		}//else if
	}
	
	// Show a confirmation box when the time taken for apply is expected to be high
	if(modifyCount > 10)
	{
		if(language == 0)
		{
			alert("This operation may take a long time. Please do not navigate away from this page or close the browser till the confirmation box is shown.");
		}
		else
		{
			alert("该操作将会需要很长时间，请不要跳转其它页面或者关闭浏览器直到成功设置确认框弹出为止。");
		}
	}
	
	setPostData();	
	setAcGroupData();
}
